// Version/Precision tags are added programmatically on shader load

attribute vec3 vPosition;

uniform mat4  mProj;
uniform mat4  mView;
uniform vec3  uLightPos;
uniform vec3  uEyePosition;
uniform float uWaterLevel;

varying vec3 L; // Light
varying vec3 P; // Position

varying float fogValue;

void main()
{
  P = vPosition;
  
  L = normalize(uLightPos);

  // Fog
  #ifdef FOG
    #define FOG_A %
    #define FOG_B %

    vec3 rayDir = vPosition - uEyePosition;
    float distance = length(rayDir);
    rayDir = normalize(rayDir);
    fogValue = FOG_A*exp(-uEyePosition.z*FOG_B)*(1.0-exp(-distance*rayDir.z*FOG_B))/rayDir.z;
    fogValue = clamp(fogValue, 0.0, 1.0);
  #else
    fogValue = 0.0;
  #endif

  gl_Position = mProj * mView * vec4(vPosition.xy, uWaterLevel, 1.0);
}